	close all, clear all, clc
	M = 5; wcT = 0.1*pi; wsT = pi/M; dc = 0.01; ds = 0.001; 
	[N, Be, D, W] = HERRMANN_LP_FIR_ORDER([wcT,wsT], [dc ds]); 
	% Increase N to 54
	[h, Err] = REMEZ_FIR(N+3, Be, D, W, 'm');
	wT = linspace(0,pi,1000);
	H = freqz(h,1,wT);
	subplot(2,1,1), PLOT_MAG_Z_dB(wT, H, pi, 80, 'H') 
	subplot(2,1,2) 
	wT = linspace(0,0.2*pi,1000);
	for k = 1:4	
		H = freqz(h,1,wT-2*pi*k/M);
		PLOT_MAG_Z_dB(wT, H, 0.2*pi, 80, 'Aliasing')
		hold on 
	end 
	grid on, zoom on
	
	
